<?php
session_start();
require_once '../config/db.php';

// التحقق من صلاحية الدخول
if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'admin') {
    header('Location: ../src/login.php');
    exit;
}

// إضافة مشروع جديد
if (isset($_POST['add_project'])) {
    $name = trim($_POST['name']);
    $location = trim($_POST['location']);
    $description = trim($_POST['description']);
    $area = floatval($_POST['area']);
    $units_count = intval($_POST['units_count']);
    $status = $_POST['status'];
    $finish_date = $_POST['finish_date'] ?: null;
    $price_from = floatval($_POST['price_from']);
    $price_to = floatval($_POST['price_to']);
    $stmt = $pdo->prepare('INSERT INTO projects (name, location, description, area, units_count, status, finish_date, price_from, price_to) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)');
    $stmt->execute([$name, $location, $description, $area, $units_count, $status, $finish_date, $price_from, $price_to]);
}

// حذف مشروع
if (isset($_GET['delete'])) {
    $id = intval($_GET['delete']);
    $stmt = $pdo->prepare('DELETE FROM projects WHERE id = ?');
    $stmt->execute([$id]);
}

// تعديل مشروع
if (isset($_POST['edit_project'])) {
    $id = intval($_POST['id']);
    $name = trim($_POST['name']);
    $location = trim($_POST['location']);
    $description = trim($_POST['description']);
    $area = floatval($_POST['area']);
    $units_count = intval($_POST['units_count']);
    $status = $_POST['status'];
    $finish_date = $_POST['finish_date'] ?: null;
    $price_from = floatval($_POST['price_from']);
    $price_to = floatval($_POST['price_to']);
    $stmt = $pdo->prepare('UPDATE projects SET name=?, location=?, description=?, area=?, units_count=?, status=?, finish_date=?, price_from=?, price_to=? WHERE id=?');
    $stmt->execute([$name, $location, $description, $area, $units_count, $status, $finish_date, $price_from, $price_to, $id]);
}

// جلب جميع المشاريع
$projects = $pdo->query('SELECT * FROM projects ORDER BY id DESC')->fetchAll();
?>
<!DOCTYPE html>
<html lang="ar">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>إدارة المشاريع</title>
    <link rel="stylesheet" href="../public/style.css">
    <style>
        body { background: #EEEEEE; font-family: 'Cairo', sans-serif; }
        .container { max-width: 1100px; margin: 40px auto; background: #fff; border-radius: 8px; box-shadow: 0 0 10px #31384122; padding: 32px; }
        h2 { color: #EA9218; margin-bottom: 24px; text-align: center; }
        table { width: 100%; border-collapse: collapse; margin-bottom: 32px; }
        th, td { padding: 10px; border-bottom: 1px solid #EEEEEE; text-align: center; }
        th { background: #EA9218; color: #fff; }
        .btn { padding: 6px 16px; border-radius: 4px; border: none; cursor: pointer; }
        .btn-edit { background: #3A4750; color: #fff; }
        .btn-delete { background: #d00; color: #fff; }
        .form-inline input, .form-inline select, .form-inline textarea { margin: 0 8px 8px 0; padding: 6px; }
        .form-inline { display: flex; flex-wrap: wrap; align-items: center; gap: 8px; margin-bottom: 24px; }
        textarea { resize: vertical; }
    </style>
</head>
<body>
    <div class="container">
        <h2>إدارة المشاريع</h2>
        <!-- نموذج إضافة مشروع جديد -->
        <form class="form-inline" method="post">
            <input type="text" name="name" placeholder="اسم المشروع" required>
            <input type="text" name="location" placeholder="الموقع" required>
            <textarea name="description" placeholder="وصف المشروع" rows="2" required></textarea>
            <input type="number" name="area" placeholder="المساحة (م²)" step="0.01" required>
            <input type="number" name="units_count" placeholder="عدد الوحدات" required>
            <select name="status">
                <option value="مكتمل">مكتمل</option>
                <option value="تحت الانشاء">تحت الإنشاء</option>
                <option value="تم البيع">تم البيع</option>
            </select>
            <input type="date" name="finish_date" placeholder="تاريخ الإنجاز">
            <input type="number" name="price_from" placeholder="السعر من" step="0.01">
            <input type="number" name="price_to" placeholder="السعر إلى" step="0.01">
            <button class="btn" type="submit" name="add_project">إضافة مشروع</button>
        </form>
        <!-- جدول المشاريع -->
        <table>
            <tr>
                <th>الرقم</th>
                <th>اسم المشروع</th>
                <th>الموقع</th>
                <th>الوصف</th>
                <th>المساحة</th>
                <th>عدد الوحدات</th>
                <th>الحالة</th>
                <th>تاريخ الإنجاز</th>
                <th>السعر من</th>
                <th>السعر إلى</th>
                <th>تعديل</th>
                <th>حذف</th>
            </tr>
            <?php foreach ($projects as $project): ?>
            <tr>
                <form method="post">
                    <td><?= $project['id'] ?></td>
                    <td><input type="text" name="name" value="<?= htmlspecialchars($project['name']) ?>" required></td>
                    <td><input type="text" name="location" value="<?= htmlspecialchars($project['location']) ?>" required></td>
                    <td><textarea name="description" rows="2" required><?= htmlspecialchars($project['description']) ?></textarea></td>
                    <td><input type="number" name="area" value="<?= $project['area'] ?>" step="0.01" required></td>
                    <td><input type="number" name="units_count" value="<?= $project['units_count'] ?>" required></td>
                    <td>
                        <select name="status">
                            <option value="مكتمل" <?= $project['status']=='مكتمل'?'selected':'' ?>>مكتمل</option>
                            <option value="تحت الانشاء" <?= $project['status']=='تحت الانشاء'?'selected':'' ?>>تحت الإنشاء</option>
                            <option value="تم البيع" <?= $project['status']=='تم البيع'?'selected':'' ?>>تم البيع</option>
                        </select>
                    </td>
                    <td><input type="date" name="finish_date" value="<?= $project['finish_date'] ?>"></td>
                    <td><input type="number" name="price_from" value="<?= $project['price_from'] ?>" step="0.01"></td>
                    <td><input type="number" name="price_to" value="<?= $project['price_to'] ?>" step="0.01"></td>
                    <td>
                        <input type="hidden" name="id" value="<?= $project['id'] ?>">
                        <button class="btn btn-edit" type="submit" name="edit_project">تعديل</button>
                    </td>
                    <td>
                        <a class="btn btn-delete" href="?delete=<?= $project['id'] ?>" onclick="return confirm('هل أنت متأكد من حذف المشروع؟');">حذف</a>
                    </td>
                </form>
            </tr>
            <?php endforeach; ?>
        </table>
    </div>
</body>
</html>
